def "bind ls" []  {
  findmnt --list | lines | split column -r " +" | reject 0 |
  rename bind source scheme mode | reject mode }

def "bind describe" [place: path] {
  bind ls | where bind == ($place | path expand)
}

def "bind chec" [place:path] {
  not (bind describe $place | is-empty)
}

def unbind [...places:path] {
  $places | each {glob $in} | flatten |
  each {|place| sudo umount $place; try {rmdir $place} }
}

def bind [source:string, place?:path] {
  let place = either $place $source | path expand
  if (bind chec $place) {
    echo $"($place) is already bound:"; return (bind describe $place) }
  if ($place | path type) == "dir" {
    try { rmdir $place } catch {
      echo $"($place) is already holding nodes on local disc."
      return (ls $place);
    } }
  mkdir $place;
  sudo mount -t nfs -o nolock $"10.0.0.192:/volume1/($source)" $place;
  bind describe $place
}

def "bind cache" [] { bind cache.channel ~/.cache.channel; }
