def "deps rust" [] {
  tree -afix --noreport
  | rg Cargo.toml | lines
  | each { open $in }
  | each {|d| try {
  { name: ($d.package.name),
    deps: ($d.dependencies | transpose d sub | each {|dep|
      $"($dep.d)@(try { $dep.sub.version } catch {''})" })
} } } }

# https://www.mermaidchart.com/play#pako:
def "deps graph rust" [] {
  (["---" $"title: (pwd | path basename)" "---" "stateDiagram-v2"] ++
    (deps rust | each {|d| $d.deps | each {
      $"  ($d.name | str replace -a '-' '_') --> ($in | str replace -r '@.*' '' | str replace -a '-' '_')"
    } } | flatten)
  ) | str join "\n" | save -f deps.mermaid
}
