def "build scope" [] {
  (rg 'def "[a-zA-Z0-9 ]+"' ~/.config/nushell --color=never -N -o -I | lines
  ) ++ ( rg 'def [a-zA-Z0-9]+' ~/.config/nushell --color=never -N -o -I | lines
  ) | split column ' ' --number 2 | get column2 |
  str replace -a ' ' '_' |
  str replace -r '^"' '' |
  str replace -r '"$' ''
}

def "build docs" [] {
  'nushell/nushell.github.io' | hub place | mkcd
  make_docs
  let build = (build scope)
  let guides = (
    ls commands/docs/*
    | where type == file
    | get name
    | path parse
    | where stem in $build
    | path join
  )
  rsync -av --delete ...($guides) ~/.build/share/
}

# optional helper to run make_docs in a new subshell with core plugins installed
#
# To use:
# `source make_docs`
# `make_docs` or `make_docs path_to_nu`
def make_docs [
    nu_path?: path     # Path to the Nushell executable to use
] {
  'nushell/nushell.github.io' | hub place | mkcd
  let $nu_path = ($nu_path | default $nu.current-exe)
  run-external $nu_path "make_docs.nu"
}
