# As much as possible, each code line is made up as a single command.
# Similar commands are grouped under common names, and included as modules.

source ./grammar.nu
source ./day.nu
source ./node.nu
source ./nix.nu
source ./disc.nu

source ./appraise.nu
source ./code.nu
source ./deps.nu
source ./diagram.nu
source ./machine.nu
source ./domain.nu
source ./place.nu
source ./log.nu
source ./command.nu
source ./bind.nu
source ./camera.nu
source ./gram.nu
source ./hex.nu
source ./hub.nu
source ./lab.nu
source ./lxc.nu
source ./map.nu
source ./media.nu
source ./page.nu
source ./press.nu
source ./program.nu
source ./quick.nu
source ./relay.nu
source ./scan.nu
source ./screen.nu
source ./session.nu
source ./share.nu
source ./signal.nu
source ./charge.nu

# Unused
# source ./cal.nu
# source ./rad.nu

source ./guide.nu

# plugins and such:

# cache ~/.local/share/atuin/init.nu { atuin init nu }
if not ('~/.local/share/atuin/init.nu' | path expand | path exists) {
  mkdir ~/.local/share/atuin/;
  atuin init nu | str replace -a ' get -i ' ' get -o ' | save -f ~/.local/share/atuin/init.nu }
source ~/.local/share/atuin/init.nu

# cache ~/.zoxide.nu { zoxide init nushell }
if not ('~/.zoxide.nu' | path expand | path exists) {
  zoxide init nushell | save -f ~/.zoxide.nu }
source ~/.zoxide.nu

# cache ~/.cache/starship/init.nu { starship init nu }
if not ('~/.cache/starship/init.nu' | path expand | path exists) {
  mkdir ~/.cache/starship;
  starship init nu | save -f ~/.cache/starship/init.nu }
source ~/.cache/starship/init.nu
