source ./grammar.nu

def "relay handler" [h: record] { $h |
  replace ($h.handler == 'reverse_proxy') { $"pass -> ($h.upstreams.dial | str join ', ' )" } |
  replace ($h.handler == 'static_response') {$"headers \(($h.headers | to toml | str trim)\)> send ($h.status_code)" } |
  replace ($h.handler == 'subroute') { $h.routes.0.handle | each {|sh| relay handler $sh } | str join "> " } |
  replace ($h.handler == 'vars') { $"\(($h | reject 'handler' | to toml | str trim)\)" } |
  replace ($h.handler == 'file_server') { "files" }
}

def "relay describe" [proc?: closure] {
  http get http://localhost:2019/config/apps/http/servers/srv0/routes |
  each { {
    domain: ($in.match.host | flatten | str join ", "),
    relay: ($in.handle.0.routes | each {|r| $r.handle | each {|h| relay handler $h } | str join " // " })
  } } |
  replace ($proc | is-not-empty) { do $proc } |
  to yaml | str replace --all "\n-" "\n\n-"
}
