source "./gram.nu"
def reshare [node: string] { nsh miniserve miniserve $node; }

def share [nodes: list<path> = [], place?: string] {
  let $place = if ($place | is-empty) { "" } else { $place }
  $nodes | each {|node| print $"Sharing: ($node) -> ($grams.share.domain)/($place)" }
  shell $grams.share.machine $"mkdir 'share/(dirname $place)'"
  time rsync -av ...($nodes | path expand) $"(machine address $grams.share.machine):~/share/($place)" }
