source ../nix.nu

def "appraise upgrade py" [] {
  let prog = open pyproject.toml

  # [upgrade] handle many commands in one `schema.commands`
  let pytest_cmds = $prog.tool.tox.env | transpose name schema | where {
    $in.schema.commands.0.0 == pytest
     # and not ("-v" in $in.schema.commands.0)
  }

  let cmds = $prog.tool.tox.env | transpose name schema | get schema.commands.0
  $cmds
  | where { $in.0 == 'pytest' }
  | each { ([$in.0 "-v"] ++ ($in | reject 0)) | uniq | str join " " }
  | enumerate
  | each { let name = $"spec.($in.index)"
    nd pixi task add --feature test $name $in.item;
    $name }

  # let upgrades = $pytest_cmds | each {|cmd|
  #   let u = ([tool tox env $cmd.name commands 0] | into cell-path)
  #   let c = $prog | get $u
  #   { name: $u, commands: ([$c.0 "-v"] ++ ($c | reject 0)) }
  #   # $c | update $"tool.tox.env.($cmd.name).commands.0"
  # }

  # [ $prog ...($upgrades) ]
  # | reduce {|i| update $i.name $i.commands}
  # | save -f pyproject.toml
}
