def "disc zfs pool" --wrapped [label: string,
  --raidz2 (-2): list<string> = []
  --raidz1 (-1): list<string> = []
  --mirror: list<string> = []
  --spares (-s): list<string> = []
  --run (-r)
  ...remaining: string # here you can use normal zpool options, like -f and -o.
] {
  let assigns = { raidz2: $raidz2, raidz1: $raidz1, spares: $spares, mirror: $mirror }
  let command = [ sudo zpool create ...$remaining $label
    ($assigns | transpose class labels | each {
      if not ($in.labels | is-empty) {
        [ $in.class ...(disc glob ...$in.labels) ]
      } }) ] | flatten | flatten | str join ' '
  if $run { nsh zfs $command; nsh zfs $"sudo zpool set failmode=continue ($label)" }
  $command
}

def "disc zfs map" --wrapped [label: string, bind: path,
  --compress (-c): string,
  --secure (-s),
  --run (-r)
  ...remaining: string # here you can use normal zpool options, like -f and -o.
] {
  let ops = $remaining ++ (
    if not ($compress | is-empty) { [
      -o $"compression=($compress)"
    ]} else { [] }
    ) ++ (if $secure { [
      -o encryption=on
      -o keylocation=prompt
      -o keyformat=passphrase
    ]} else { [] }) |
    str join " "
  let command = [
    $"zfs create ($ops) ($label)"
    $"zfs set mountpoint=($bind) ($label)"
  ] | str join '; '
  if $run { sudo nu -e ($command + "; exit"); sudo chown (whoami) $bind; }
  $command
}

def "disc zfs query" [--bound (-b), --unbound (-u)] {
  let labels = (zfs list | from ssv | where NAME =~ '/').NAME
  let sizes = disc size | where label in $labels
  if $bound { $sizes
  } else if $unbound { $labels | exclude { $in in $sizes.label }
  } else { $labels }
}

def "disc zfs load" [...labels: string] {
  if ($labels | all { $in in (disc query -b).label }) { return }
  try { sudo zpool import -a }
  if ($labels | is-empty) { sudo zfs mount -a -l -v
  } else {
    sudo zfs mount -l -v ...($labels | where { not ($in in (disc query -b).label) })
} }

def "disc zfs unload" [...labels: string] {
  if ($labels | is-empty) { sudo zfs unmount -a -u
  } else { $labels | each { sudo zfs unmount -u $in }
} }

