---
title: do
categories: |
  core
version: 0.105.1
usage: |
  Run a closure, providing it with the pipeline input.
editLink: false
contributors: false
---
<!-- This file is automatically generated. Please edit the command in https://github.com/nushell/nushell instead. -->

# `do` for [core](/commands/categories/core.md)

<div class='command-title'>Run a closure, providing it with the pipeline input.</div>

## Signature

```> do {flags} (closure) ...rest```

## Flags

 -  `--ignore-errors, -i`: ignore errors as the closure runs
 -  `--capture-errors, -c`: catch errors as the closure runs, and return them
 -  `--env`: keep the environment defined inside the command

## Parameters

 -  `closure`: The closure to run.
 -  `...rest`: The parameter(s) for the closure.


## Input/output types:

| input | output |
| ----- | ------ |
| any   | any    |
## Examples

Run the closure
```nu
> do { echo hello }
hello
```

Run a stored first-class closure
```nu
> let text = "I am enclosed"; let hello = {|| echo $text}; do $hello
I am enclosed
```

Run the closure and ignore both shell and external program errors
```nu
> do --ignore-errors { thisisnotarealcommand }

```

Abort the pipeline if a program returns a non-zero exit code
```nu
> do --capture-errors { nu --commands 'exit 1' } | myscarycommand

```

Run the closure with a positional, type-checked parameter
```nu
> do {|x:int| 100 + $x } 77
177
```

Run the closure with pipeline input
```nu
> 77 | do { 100 + $in }
177
```

Run the closure with a default parameter value
```nu
> 77 | do {|x=100| $x + $in }
177
```

Run the closure with two positional parameters
```nu
> do {|x,y| $x + $y } 77 100
177
```

Run the closure and keep changes to the environment
```nu
> do --env { $env.foo = 'bar' }; $env.foo
bar
```
