---
title: help
categories: |
  core
version: 0.105.1
usage: |
  Display help information about different parts of Nushell.
editLink: false
contributors: false
---
<!-- This file is automatically generated. Please edit the command in https://github.com/nushell/nushell instead. -->

# `help` for [core](/commands/categories/core.md)

<div class='command-title'>Display help information about different parts of Nushell.</div>

## Signature

```> help {flags} ...rest```

## Flags

 -  `--find, -f {string}`: string to find in command names, descriptions, and search terms

## Parameters

 -  `...rest`: The name of command, alias or module to get help on.


## Input/output types:

| input   | output |
| ------- | ------ |
| nothing | any    |
## Examples

show help for single command, alias, or module
```nu
> help match

```

show help for single sub-command, alias, or module
```nu
> help str join

```

search for string in command names, descriptions, and search terms
```nu
> help --find char

```

## Notes
`help word` searches for "word" in commands, aliases and modules, in that order.

## Subcommands:

| name                                                                 | description                               | type     |
| -------------------------------------------------------------------- | ----------------------------------------- | -------- |
| [`help aliases`](/commands/docs/help_aliases.md)                     | Show help on nushell aliases.             | built-in |
| [`help commands`](/commands/docs/help_commands.md)                   | Show help on nushell commands.            | built-in |
| [`help escapes`](/commands/docs/help_escapes.md)                     | Show help on nushell string escapes.      | built-in |
| [`help externs`](/commands/docs/help_externs.md)                     | Show help on nushell externs.             | built-in |
| [`help modules`](/commands/docs/help_modules.md)                     | Show help on nushell modules.             | built-in |
| [`help operators`](/commands/docs/help_operators.md)                 | Show help on nushell operators.           | built-in |
| [`help pipe-and-redirect`](/commands/docs/help_pipe-and-redirect.md) | Show help on nushell pipes and redirects. | built-in |