#!/bin/bash

echo "Preparing Fedora."
yum upgrade -y
yum install -y \
  automake \
  bison \
  bzip2 \
  cmake \
  curl \
  elixir \
  fedora-packager \
  fedpkg \
  freeglut-devel \
  gcc \
  gdbm-devel \
  git \
  glfw \
  gnome-tweaks \
  go \
  grubby \
  hamlib \
  hamlib-devel \
  hg \
  htop \
  ibus-pinyin \
  inkscape \
  kernel-{devel,tools,headers} \
  libffi \
  libffi-devel \
  libjpeg \
  libyaml \
  libyaml-devel \
  make \
  ncurses-devel \
  neovim \
  nss \
  openscad \
  openssl-devel \
  pandoc \
  podman \
  podman-docker \
  poppler \
  postgresql \
  postgresql-contrib \
  postgresql-devel \
  postgresql-server \
  prusa-slicer \
  pulseaudio-libs-devel \
  pytest \
  python-pip \
  python-setuptools \
  readline \
  readline-devel \
  ripgrep \
  rpi-imager \
  rpmdevtools \
  rtaudio \
  snapd \
  sudo \
  sway \
  the_silver_searcher \
  transmission \
  ucview \
  wireshark \
  zip \
  zlib-devel \

# vlc
yum install -y https://download1.rpmfusion.org/free/fedora/rpmfusion-free-release-$(rpm -E %fedora).noarch.rpm
yum install -y https://download1.rpmfusion.org/nonfree/fedora/rpmfusion-nonfree-release-$(rpm -E %fedora).noarch.rpm
yum install -y vlc

# node
yum install -y curl gawk gnupg2
# ruby
yum install -y gcc rust patch make bzip2 openssl-devel libyaml-devel libffi-devel readline-devel zlib-devel gdbm-devel ncurses-devel

# no package on fedora:
# build-essential \
# digest \
# docker-compose \
# dropbox \
# easy_install \
# geckodriver \
# libdigest \
# libvolk \
# obs \
# psych \
# python-dev \

# seemingly unused:
# gtk3-devel qt3-devel libXi-devel gcc-c++ \

systemctl enable podman.socket
systemctl start podman.socket
systemctl enable postgresql
if [ ! -d /var/lib/pgsql/data ]; then
  postgresql-setup --initdb --unit postgresql
fi
systemctl start postgresql

gsettings set org.gnome.mutter experimental-features "['scale-monitor-framebuffer']"
