{ lib, pkgs, edge, ... }:
{
  systemd = { suppressedSystemUnits = [ # Supress some systemd modules in LXC
    "dev-mqueue.mount" "sys-kernel-debug.mount" "sys-fs-fuse-connections.mount" ];
    services."getty@tty1" = { enable = lib.mkForce true; wantedBy = [ "getty.target" ]; serviceConfig.Restart = "always"; };
    # stateVersion = "23.11";
  };

  services.openssh = { enable = true;
    settings.PasswordAuthentication = false;
    settings.KbdInteractiveAuthentication = false;
    settings.PermitRootLogin = "yes"; };

  networking = {
    defaultGateway = { address = "10.0.0.1"; interface = "eth0"; }; nameservers = [ "1.1.1.1" ];
    interfaces = { eth0.ipv4.addresses = [{ address = "10.0.0.205"; prefixLength = 24; }]; };
    firewall = { allowedTCPPorts = [ 22 8080 ]; };
  };

  environment.systemPackages = with pkgs; [
    neovim binutils git (beam.packagesWith erlang_26).elixir_1_16 rsync edge.nushell
  ];
}
