{ config, pkgs, lib, home-manager, nixos-hardware, ... }:

{ imports = [ "${home-manager}/nixos"
    "${nixos-hardware}/framework/13-inch/11th-gen-intel/default.nix"
    ./base.nix ./package.nix ./home.nix ./process.nix
  ];

  users.defaultUserShell = pkgs.zsh;
  users.users = {
    mesh = { isNormalUser = true; extraGroups = [ "wheel" "docker" ]; };
    # ceph = { isNormalUser = true; extraGroups = [ "wheel" "ceph" ]; };
  };
  # users.groups.ceph = {};

  fileSystems = {
    "/eco/pond" = { device = "/dev/nvme0n1p4"; fsType = "ext4"; };
    "/cache/channel" = {
      device = "10.0.0.192:/volume1/cache.channel";
      fsType = "nfs";
      options = ["x-systemd.automount" "noauto" "x-systemd.idle-timeout=720"];
    };
  };
}

# reminder: run `passwd`

# Edit this configuration file to define what should be installed on
# your system.  Help is available in the configuration.nix(5) man page
# and in the NixOS manual (accessible by running `nixos-help`).

#networking.hostName = "nix"; # Machine name
#i18n.defaultLocale = "en_US.UTF-8";
# Recommended: back up machine, and upgrade each year on `-05` minor releases.
# (e.g. man configuration.nix or on https://nixos.org/nixos/options.html).
#system.stateVersion = "23.05";
# time.timeZone = "Europe/Amsterdam"; choose a zone.


#boot = { loader.efi.canTouchEfiVariables = true;
#  initrd.luks.devices.base ={device="/dev/nvme0n1p3"; preLVM=true;};
#  loader.grub = { device="/dev/nvme0n1";
#    enable = true; version = 2; useOSProber = true; efiSupport = true; }; };

#networking.networkmanager.enable = true;
# Pick only one of the below networking options.
# networking.wireless.enable = true;  # Enables wireless support via wpa_supplicant.
# networking.networkmanager.enable = true;  # Easiest to use and most distros use this by default.

# Need a proxy?
# networking.proxy.default = "http://user:password@proxy:port/";
# networking.proxy.noProxy = "127.0.0.1,localhost,internal.domain";

# use xkbOptions in tty.
# console = { font = "Lat2-Terminus16"; keyMap = "us"; useXkbConfig = true; };

# Some programs need SUID wrappers;
# userspace sessions described here.
# programs.mtr.enable = true;
# programs.gnupg.agent = { enable = true; enableSSHSupport = true; };

# Open ports in the firewall.
# networking.firewall.allowedTCPPorts = [ ... ];
# networking.firewall.allowedUDPPorts = [ ... ];
# Or disable the firewall altogether.
# networking.firewall.enable = false;
