{ options, ... }: {
  services.openssh.enable = true;
  networking = {
    usePredictableInterfaceNames = true;
    firewall = { enable = true; allowedTCPPorts = [
      22 80 443
      2222 3000 4000
    ]; };

    networkmanager = { enable = true; appendNameservers = [ "1.1.1.1" "9.9.9.9" ]; };
    timeServers = options.networking.timeServers.default ++ ["time.nist.gov"];
  };
}
