{ channel, domain }:
{ options, config, pkgs, lib, ... }:
let
db = { name = "wiki"; channel = 5432; };
in {
  networking.firewall.allowedTCPPorts = [ channel db.channel ];

  services = {

    wiki-js = {
      enable = true;
      settings = {
        # db.host = "127.0.0.1";
        db.host = "/var/run/postgresql";
        db.user = "postgres";
        db.db = db.name;
        port = channel;
      };
    };

    caddy = {
      enable = true;
      virtualHosts.${domain}.extraConfig = ''
      reverse_proxy 127.0.0.1:${toString channel}
      log {
        output file /var/lib/caddy/${domain}.log {
          roll_size     200MiB
          roll_local_time
          roll_keep     1440
          roll_keep_for 1440d
        }
      }
      '';
    };

    # https://wiki.nixos.org/wiki/PostgreSQL
    postgresql = {
      enable = true;
      # enableTCPIP = true;
      # settings.port = db.channel;
      ensureDatabases = [ db.name ];
      authentication = pkgs.lib.mkOverride 10 ''
        local all all trust
      '';
        # host  all all 127.0.0.1/32 trust
      # identMap = ''
      #   superuser_map root postgres
      # '';
    };

  };
}
