{ pkgs, edge, ... }:
{
  # imports = [
  #   { home.file.".local/share/icons/future-cyan".source = "${fetchGit {
  #       url = "https://gitlab.com/Pummelfisch/future-cyan-hyprcursor.git";
  #       rev = "60fc69d603a6d7b99c1841a2c4cebd130b1aa357";
  #     }}/Future-Cyan-Hyprcursor_Theme";
  #   }
  # ];

  fonts.fontconfig.enable = true;
  gtk.enable = true;
  qt.enable = true;

  home.packages = with pkgs; [
    hypridle hyprlock hyprpicker hyprpanel hyprpaper waybar
    alacritty pyprland fuzzel wl-clipboard nemo grimblast grim slurp
    networkmanagerapplet pavucontrol blueberry brightnessctl
  ];
    # kitty
    # libnotify
    # font-awesome
    # wlsunset

  wayland.windowManager.hyprland = let
    console = command: "${pkgs.alacritty}/bin/alacritty -e ${edge.nushell}/bin/nu -e '${command}'";
    nu = command: "${edge.nushell}/bin/nu -l -c '${command}'";
  in {
    enable = true;
    # xwayland.enable = true;
    systemd.enable = true;
    systemd.variables = ["--all"];
    package = pkgs.hyprland;

    settings = {
      "$fileManager" = "nemo";
      "$menu" = "fuzzel";

      # see https://wiki.hyprland.org/Configuring/Binds
      # SHIFT # CAPS # CTRL/CONTROL # ALT # MOD2 # MOD3 # SUPER/WIN/LOGO/MOD4 # MOD5
      "$a" = "SHIFT";
      "$b" = "CTRL";
      "$c" = "SUPER";
      "$d" = "ALT";

      # exec = [ "nix-shell -p ntp --command ntpdate time.nist.gov" ];

      exec-once = [
        # (console "session record (sessions | get 0)")
        # "hyprctl setcursor Future-Cyan 48"
        "hypridle" "pypr" "hyprpaper" "waybar"
        # "nm-applet --indicator"
        # "dbus-update-activation-environment --systemd WAYLAND_DISPLAY XDG_CURRENT_DESKTOP"
        # "kitty +kitten panel --edge=background zellij -s log -l log"
      ];

      bind = [
        "$c, SPACE, exec, $menu"
        "$c, E, exec, $fileManager"
        "$c, slash, exec, hyprlock"
        "$c $b, slash, exec, ${nu ''ps | where name =~ 'Hyprland' | get pid | each {|p| kill $p }''}"
        "$a $d, S, exec, grimblast copysave active"

        # explore
        # "$c, F, exec, firefox"
        "$c, Z, exec, brave"

        # console sessions
        "$c, Q, exec, ${console "hop"}"
        "$c, R, exec, ${console "hop read"}"
        "$c $b, M, exec, ${console "hop muse"}"
        # "$c, I, exec, ${console "session hop issue"}"
        # "$c $a, E, exec, ${console "meli"}" # email

        # audio mixing
        "$c $a, A, exec, qjackctl"
        "$c, B, exec, blueberry"

        # end processes
        "$c, C, killactive, "
        "$c, escape, exit, "

        # connections
        "$c, X, exec, alacritty -e nmtui"
        "$c $a, X, exec, nm-connection-editor"

        # maximize
        "$c $a, M, exec, hyprctl dispatch fullscreen 1"
        "$c, M, exec, hyprctl dispatch fullscreen 0"

        # resize and arrange
        "$c, V, togglefloating, "
        "$c, P, pseudo, "
        "$c, O, togglesplit, "

        # Move focus with c + arrow keys
        "$c, left, movefocus, l"
        "$c, right, movefocus, r"
        "$c, up, movefocus, u"
        "$c, down, movefocus, d"

        "$c, H, movefocus, l"
        "$c, L, movefocus, r"
        "$c, K, movefocus, u"
        "$c, J, movefocus, d"

        "$c $a, H, swapwindow, l"
        "$c $a, L, swapwindow, r"
        "$c $a, K, swapwindow, u"
        "$c $a, J, swapwindow, d"

        # Switch workspaces with c + [0-9]
        "$c, 1, workspace, 1"
        "$c, 2, workspace, 2"
        "$c, 3, workspace, 3"
        "$c, 4, workspace, 4"
        "$c, 5, workspace, 5"
        "$c, 6, workspace, 6"
        "$c, 7, workspace, 7"
        "$c, 8, workspace, 8"
        "$c, 9, workspace, 9"
        "$c, 0, workspace, 10"

        # Move active window to a workspace with c + $a + [0-9]
        "$c $a, 1, movetoworkspacesilent, 1"
        "$c $a, 2, movetoworkspacesilent, 2"
        "$c $a, 3, movetoworkspacesilent, 3"
        "$c $a, 4, movetoworkspacesilent, 4"
        "$c $a, 5, movetoworkspacesilent, 5"
        "$c $a, 6, movetoworkspacesilent, 6"
        "$c $a, 7, movetoworkspacesilent, 7"
        "$c $a, 8, movetoworkspacesilent, 8"
        "$c $a, 9, movetoworkspacesilent, 9"
        "$c $a, 0, movetoworkspacesilent, 10"

        # Example special workspace (scratchpad)
        "$c, S, togglespecialworkspace, magic"
        "$c $a, S, movetoworkspace, special:magic"
        "$c $a, S, togglespecialworkspace, magic"

        # Scroll through existing workspaces with c + scroll
        "$c, mouse_down, workspace, e+1"
        "$c, mouse_up, workspace, e-1"

        # Quick accions using pypr
        "$c,tab,exec,pypr toggle console && hyprctl dispatch bringactivetotop"
        # "$c,F,exec,pypr toggle ranger && hyprctl dispatch bringactivetotop"
        # "$c,N,exec,pypr toggle musikcube && hyprctl dispatch bringactivetotop"
        # "$c,B,exec,pypr toggle btm && hyprctl dispatch bringactivetotop"
        # "$c,E,exec,pypr toggle geary && hyprctl dispatch bringactivetotop"
      ];

      bindm = [
        # Move/resize windows with c + LMB/RMB and dragging
        "$c, mouse:272, movewindow"
        "$c, mouse:273, resizewindow"
      ];

      # Media and audio keys!
      bindel = [
        # screen shine
        "$b $d, comma, exec,brightnessctl -d intel_backlight s 0"
        "$b $d,1,exec,brightnessctl -d intel_backlight s 10%"
        "$b $d,2,exec,brightnessctl -d intel_backlight s 20%"
        "$b $d,3,exec,brightnessctl -d intel_backlight s 30%"
        "$b $d,4,exec,brightnessctl -d intel_backlight s 40%"
        "$b $d,5,exec,brightnessctl -d intel_backlight s 50%"
        "$b $d,6,exec,brightnessctl -d intel_backlight s 60%"
        "$b $d,7,exec,brightnessctl -d intel_backlight s 70%"
        "$b $d,8,exec,brightnessctl -d intel_backlight s 80%"
        "$b $d,9,exec,brightnessctl -d intel_backlight s 90%"
        "$b $d,0,exec,brightnessctl -d intel_backlight s 100%"

        # ", XF86AudioMute, exec, wpctl set-mute @DEFAULT_AUDIO_SINK@ toggle"

        # ",XF86MonBrightnessUp,exec,nix-shell -p light --command light -S 1"
        # ",XF86MonBrightnessDown,exec,nix-shell -p light --command light -S 0"
        # ",XF86AudioNext,exec,wpctl set-volume ..."
        # ",XF86AudioPlay,exec,wpctl set-volume ..."
        # ",XF86AudioPrev,exec,wpctl set-volume ..."

        # keyboard scroll
        "$b, XF86AudioRaiseVolume, exec, hyprctl dispatch sendshortcut ',Down,active'"
        "$b, XF86AudioLowerVolume, exec, hyprctl dispatch sendshortcut ',Up,active'"
        "SHIFT_R, XF86AudioRaiseVolume, exec, hyprctl dispatch sendshortcut ',Down,active'"
        "SHIFT_R, XF86AudioLowerVolume, exec, hyprctl dispatch sendshortcut ',Up,active'"

        # Usual media keys!
        ", XF86AudioRaiseVolume, exec, wpctl set-volume -l 1.4 @DEFAULT_AUDIO_SINK@ 5%+"
        ", XF86AudioLowerVolume, exec, wpctl set-volume -l 1.4 @DEFAULT_AUDIO_SINK@ 5%-"
        ", XF86AudioMute, exec, wpctl set-mute @DEFAULT_AUDIO_SINK@ toggle "

        # Unusual media keys!
        ",Print,exec,wpctl set-volume @DEFAULT_AUDIO_SINK@ 5%-" # less loud
        "$a,Print,exec,wpctl set-volume @DEFAULT_AUDIO_SINK@ 1%-" # less loud
        "$b,Print,exec,wpctl set-volume @DEFAULT_AUDIO_SINK@ 0%"

        ",XF86AudioMedia,exec,wpctl set-volume @DEFAULT_AUDIO_SINK@ 5%+" # more loud
        "$a,XF86AudioMedia,exec,wpctl set-volume @DEFAULT_AUDIO_SINK@ 1%+" # more loud
        "$b,XF86AudioMedia,exec,wpctl set-volume @DEFAULT_AUDIO_SINK@ 100%"

      ];
    };

    extraConfig = ''
  # See https://wiki.hyprland.org/Configuring/Keywords/ for more

  # env=WLR_DRM_DEVICES,/dev/dri/card0

  cursor {
    # no_hardware_cursors = true
  }

  master {
    mfact = 0.50
    new_on_top = true
    new_status = inherit
    orientation = left
  }

  misc {
    disable_hyprland_logo = true
    disable_splash_rendering = true
  }

  # For all categories, see https://wiki.hyprland.org/Configuring/Variables/
  input {
    touchpad {
      clickfinger_behavior = 1
    }

    kb_layout = us
    kb_variant =
    kb_model =
    kb_options = ctrl:nocaps, grp:alt_shift_toggle, compose:rctrl
    kb_rules =
    follow_mouse = 1

    touchpad {
      natural_scroll = no
    }

    sensitivity = 0 # -1.0 - 1.0, 0 means no modification.
  }

  general {
      # See https://wiki.hyprland.org/Configuring/Variables/ for more
      gaps_in = 0
      gaps_out = 0
      border_size = 2
      col.active_border = rgba(33ccffee) rgba(00ff99ee) 45deg
      col.inactive_border = rgba(595959aa)

      layout = dwindle
      # layout = master

      # Please see https://wiki.hyprland.org/Configuring/Tearing/ before you turn this on
      allow_tearing = false
  }

  # decoration {
  #     # See https://wiki.hyprland.org/Configuring/Variables/ for more
  #     blur {
  #       enabled = true
  #       size = 3
  #       passes = 1
  #     }
  #     rounding = 0
  #     drop_shadow = yes
  #     shadow_range = 4
  #     shadow_render_power = 3
  #     col.shadow = rgba(1a1a1aee)
  # }

  animations {
      # enabled = yes
      enabled = no
      bezier = myBezier, 0.05, 0.9, 0.1, 1.05

      # Some default animations, see https://wiki.hyprland.org/Configuring/Animations/ for more
      animation = windows, 1, 7, myBezier
      animation = windowsOut, 1, 7, default, popin 80%
      animation = border, 1, 10, default
      animation = borderangle, 1, 8, default
      animation = fade, 1, 7, default
      animation = workspaces, 1, 6, default
  }

  dwindle {
      # See https://wiki.hyprland.org/Configuring/Dwindle-Layout/ for more
      # pseudotile = yes
      preserve_split = yes # you probably want this
  }

  gestures {
      # See https://wiki.hyprland.org/Configuring/Variables/ for more
      workspace_swipe = off
  }

  # Example per-device config
  # See https://wiki.hyprland.org/Configuring/Keywords/#executing for more
  # device:epic-mouse-v1 {
  #     sensitivity = -0.5
  # }

  # See https://wiki.hyprland.org/Configuring/Window-Rules/ for more
  # windowrulev2 = nomaximizerequest, class:.* # You'll probably like this.

  $scratchpadsize = size 80% 85%
  $scratchpad = class:^(scratchpad)$
  windowrulev2 = float,$scratchpad
  windowrulev2 = $scratchpadsize,$scratchpad
  windowrulev2 = workspace special silent,$scratchpad
  windowrulev2 = center,$scratchpad
  windowrulev2 = opacity 0.80,$scratchpad

  # Resize using keyboard arrows.
  bindl=,End,submap,resize
  submap=resize

  binde=,right,resizeactive,15 0
  binde=,left,resizeactive,-15 0
  binde=,up,resizeactive,0 -15
  binde=,down,resizeactive,0 15

  binde=$a,right,resizeactive,60 0
  binde=$a,left,resizeactive,-60 0
  binde=$a,up,resizeactive,0 -60
  binde=$a,down,resizeactive,0 60

  binde=,l,resizeactive,15 0
  binde=,h,resizeactive,-15 0
  binde=,k,resizeactive,0 -15
  binde=,j,resizeactive,0 15

  binde=$a,l,resizeactive,60 0
  binde=$a,h,resizeactive,-60 0
  binde=$a,k,resizeactive,0 -60
  binde=$a,j,resizeactive,0 60

  # keyboard scroll (including lock screen)
  bindl=,XF86AudioRaiseVolume, exec, hyprctl dispatch sendshortcut ',Down,active'
  bindl=,XF86AudioLowerVolume, exec, hyprctl dispatch sendshortcut ',Up,active'

  # lock, again
  bind=$c, slash, exec, hyprlock

  bindl=,escape,submap,reset
  bindl=,End,submap,reset
  submap=reset

    '';
  };
}
