{ config, pkgs, lib, ... }:
{
  networking = {
    nameservers = [ "1.1.1.1" ];
    defaultGateway = { address = "10.0.0.1"; interface = "enp0s13f0u3c2"; };
    interfaces.enp0s13f0u3c2.ipv4.addresses = [ { address = "10.0.0.12"; prefixLength = 24; } ];
    firewall = { enable = false; allowedTCPPorts = [ 22 9333 9360 ]; };
  };

  services.openssh = { enable = true;
    settings.PasswordAuthentication = false;
    settings.KbdInteractiveAuthentication = false;
    settings.PermitRootLogin = "yes"; };

  services.nebula.networks.mesh = {
    enable = true;
    isLighthouse = false;
    lighthouses = [ "10.10.0.1" ];
    staticHostMap = { "10.10.0.1" = ["172.233.232.194:4242"]; };
    isRelay = true;
    cert = "/etc/nebula/mesh-b.crt";
    key = "/etc/nebula/mesh-b.key";
    ca = "/etc/nebula/ca.crt";
    firewall.inbound = [ { host = "any"; port = "any"; proto = "any"; } ];
    firewall.outbound = [ { host = "any"; port = "any"; proto = "any"; } ];
    settings.punchy = { punch = true; punch_back = true; respond = true; };
  };

  systemd.services."kelp" = { enable = true;
    description = "yummy 'cords synchronized in a simple cadence; based on SeaweedFS.";
    unitConfig = { After = "local-fs.target"; Wants = "local-fs.target"; };
    serviceConfig = {
      Type = "oneshot";
      KillMode = "mixed";
      ExecStart = "/bin/sh -c '${pkgs.seaweedfs}/bin/weed server -ip 10.10.0.12 -master.port=9333 -dir=/eco/pond -volume.port=9360 -master.peers=10.10.0.11:9333,10.10.0.12:9333,10.10.0.13:9333'";
      TimeoutSec = 0;
    };
    environment = { PATH = lib.mkForce "/run/current-system/sw/bin/"; };
    wantedBy = ["multi-user.target"];
  };
}
