{ home-manager, nixos-hardware, pkgs, pool, ... }@sources:
let lib = sources.nixpkgs.lib; in
lib.nixosSystem {
  specialArgs = sources;
  modules = [

    (import ../../module/login.nix rec {
      user = "calliope";
      command = "Hyprland";
      init = { inherit command user; };
    })

    "${nixos-hardware}/framework/13-inch/11th-gen-intel/default.nix"
    home-manager.nixosModules.default

    ({ networking.hostName = "chesapeake"; })
    (pool.channel.${sources.arch} "wlp170s0")
    ../../mach/base.nix

    ./machine.nix
    ./signal.nix
    ./process.nix

    ../../home/record.nix
    (import ../../module/user.nix { name = "calliope"; super = true; })
    (import ../../module/hypr.nix { user = "calliope"; })

    ../../module/essence.nix
    ../../module/console.nix
    ../../module/energy.nix
    ../../module/language.nix
    ../../module/media.nix
    ../../module/psql.nix
    ../../module/upgrade.nix
    ../../module/zfs.nix

    # ../../home/base.nix
    # ../../module/arduino.nix
    # ../../module/cosmic.nix
    # ../../module/relay.nix
    # ../../module/tabfs.nix

    ( import ../../module/mesh.nix {
      machine = "chesapeake";
      mesh = "mesh";
      beacons = [ "10.0.10.100" "10.0.10.101" ];
      map = {
        "10.0.10.100" = [ "173.66.32.84:4242" ];
        "10.0.10.101" = [ "173.66.32.84:4243" ];
      };
    })

  ];
}
