{ pkgs, edge, nixpkgs, home-manager, ...}: #nixos-hardware, nixpkgs, microvm, ... }@sources:
let lib = nixpkgs.lib; in
lib.nixosSystem {
  specialArgs = { inherit pkgs edge; };
  modules = [
    home-manager.nixosModules.default

    (import ../../module/login.nix {
      user = "nixos";
      command = ''nu -e "hop home"'';
    })

    ./signal.nix
    ./machine.nix
    ./process.nix

    (import ../../module/user.nix { name = "calliope"; })
    (import ../../module/user.nix { name = "nixos"; super = true; })

    # microvm.nixosModules.host
    # ../../micro/index.nix

    ({ networking.hostName = "pebble"; })
    ../../mach/base.nix

    ../../module/essence.nix
    # ../../module/console.nix
    # ../../module/helix.nix
    # ../../module/language.nix
    # ../../module/look.nix
    # ../../module/process.nix
    # ../../module/relay.nix
    # ../../module/session.nix
    # ../../module/upgrade.nix

    # ( import ../../gram/elixir.nix {
    #   base = "operand"; name = "op"; domain = "operand.online"; channel = 4000;
    #   user = "nixos"; codebase = "base.operand.online:op";
    # })

    ../../module/lobby.nix

    (import ../../module/proxy.nix {
      channel = 8080;
      domain = "shiori.operand.online";
      name = "shiori";
      node = "10.0.10.1";
    })

    # (import ../../module/proxy.nix {
    #   channel = 3000;
    #   domain = "node.operand.online";
    #   name = "node-op";
    #   node = "10.0.10.1";
    # })

    ( let name = "base"; domain = "base.operand.online"; node = "10.0.10.10";
      channels = [ 2202 9418 4401 23233 ];
    in { services.caddy = {
      enable = true; dataDir = "/var/lib/caddy";
      virtualHosts = builtins.listToAttrs (builtins.map (chan:
      { name = "${domain}:${toString chan}";
        value = { extraConfig = ''
        reverse_proxy ${node}:${toString chan}
        log {
          output file /var/lib/caddy/${name}-${toString chan}.log {
            roll_size     200MiB
            roll_local_time
            roll_keep     1440
            roll_keep_for 1440d
          }
        }''; };
      }) channels);
    }; })

    ({
      environment.systemPackages = with pkgs; [ nebula ];
      services.nebula.networks.mesh = {
        enable = true;
        isLighthouse = true;
        # isRelay = false;
        # relays = [ "10.0.10.100" ];
        lighthouses = [ "10.0.10.100" "10.0.10.101" ];
        settings = {
          cipher = "aes";
          punchy = { punch = true; respond = true; };
          preferred_ranges = ["192.168.1.0/24"];
        };
        cert = "/etc/nebula/pebble.baseline.crt";
        key = "/etc/nebula/pebble.baseline.key";
        ca = "/etc/nebula/ca.crt";

        # staticHostMap = { "10.0.10.1" = [ "173.66.32.84:4242" ]; };
        firewall.outbound = [ { host = "any"; port = "any"; proto = "any"; } ];
        firewall.inbound = [ { host = "any"; port = "any"; proto = "any"; } ];

        listen.port = 4243;
        staticHostMap = {
          "10.0.10.100" = [ "173.66.32.84:4242" ];
          "10.0.10.101" = [ "173.66.32.84:4243" ];
        };
      };
    })

  ];
}
