{ pkgs, ... }:
{
  security.rtkit.enable = true;
  security.pam.services.swaylock = {};
  environment.sessionVariables.NIXOS_OZONE_WL = "1";

  # a number of forum pages describe the same error... only one had a good resolution.
  # https://discourse.nixos.org/t/rebuild-error-failed-to-start-network-manager-wait-online/41977
  systemd.network.wait-online.enable = false;
    # ProtectHome
    # NoNewPrivileges = true;
    # ProtectKernelLogs = true;
    # ProtectKernelModules = true;
    # ProtectKernelTunables = true;
  # }

  boot.initrd.systemd.network.wait-online.enable = false;

  services = {
    atuin.enable = true;
    dbus.enable = true;
    ntp.enable = true;
    xserver = { enable = true;
      videoDrivers = [ "modesetting" ];
    };

    pulseaudio = { enable = false; extraConfig = "load-module module-switch-on-connect"; };
  };
}
