{ options, _lib, ... }: {
  services.openssh = {
    enable = true;
    ports = [ 22 2201 ];
    settings.PasswordAuthentication = false;
  };

  networking = {
    usePredictableInterfaceNames = true;
    firewall = { enable = true;
      allowedTCPPorts = [ 22 2201 80 443 ];
      allowedUDPPorts = [ 60001 ];
    };

    # firewall.trustedInterfaces = [ "tailscale0" ];
    networkmanager = { enable = true; appendNameservers = [ "1.1.1.1" "9.9.9.9" ]; };
    # useDHCP = lib.mkForce true;

    defaultGateway = { address = "192.168.1.1"; interface = "end0"; };
    interfaces.end0.ipv4.addresses = [ { address = "192.168.1.101"; prefixLength = 24; } ];

#     extraHosts = ''
# 10.0.0.194 *.operand.online
# '';
    timeServers = options.networking.timeServers.default ++ ["time.nist.gov"];
  };
    # ntp.servers = [ "time.nist.gov" ];
    # openntpd = { enable = true; servers = [ "time.nist.gov" ]; };
  services.timesyncd = { enable = true; servers = [ "time.nist.gov" ]; };
}
