# see https://charm.sh/blog/self-hosted-soft-serve/
{ pkgs, ...}:
{
  services.soft-serve = {
    enable = true;
    settings =  {
      name = "base.operand.online";
      log_format = "text";
      ssh = {
        listen_addr = ":2202";
        public_url = "ssh://base.operand.online:2202";
        max_timeout = 30;
        idle_timeout = 6;

        # cors = {
        #   allowed_headers = [
        #     "Accept"
        #     "Accept-Language"
        #     "Content-Language"
        #     "Origin"
        #     "Content-Type"
        #     "X-Requested-With"
        #     "User-Agent"
        #     "Authorization"
        #     "Access-Control-Request-Method"
        #   ];
        #   allowed_origins = [ "*" ];
        #   allowed_methods = [ "OPTIONS" "GET" "HEAD" "POST" "PUT" ];
        # };

      };
      git = {
        listen_addr = ":9418";
        max_timeout = 30;
        max_connections = 6;
        idle_timeout = 6;
      };

      http = {
        listen_addr = "127.0.0.1:4401";
        public_url = "https://base.operand.online";

        # cors = {
        #   allowed_headers = [
        #     "Accept"
        #     "Accept-Language"
        #     "Content-Language"
        #     "Origin"
        #     "Content-Type"
        #     "X-Requested-With"
        #     "User-Agent"
        #     "Authorization"
        #     "Access-Control-Request-Method"
        #   ];
        #   allowed_origins = [ "*" ];
        #   allowed_methods = [ "OPTIONS" "GET" "HEAD" "POST" "PUT" ];
        # };

      };
      stats.listen_addr = ":23233";
      # initial_admin_keys = [ ];
    };
  };
  networking.firewall = { enable = true;
    allowedTCPPorts = [ 2202 9418 4401 23233 ];
  };

  services.caddy = { enable = true;
    virtualHosts."base.operand.online".extraConfig = ''
    reverse_proxy http://127.0.0.1:4401
    log {
      output file /var/lib/caddy/base.operand.online.log {
        roll_size     200MiB
        roll_local_time
        roll_keep     1440
        roll_keep_for 1440d
      }
  }''; };

}
