{ name, shell ? null, super ? false, ... }@call:
{...}@sources:
let

groups = if super
  then [ "wheel" "networkmanager" "acme" "dialout" ]
  else [];

p = if sources ? edge
  then sources.edge
  else sources.pkgs;

s = if call ? shell
  then shell
  else p.nushell;

in {
  users.defaultUserShell = s;
  users.users.${name} = { isNormalUser = true; shell = s; extraGroups = groups; };
  home-manager.users.${name}.home.stateVersion = "25.05";
}
