#!/bin/bash
set -e

if [ ! -d ~/src/radio ]; then
  mkdir -p ~/src/radio
  cd ~/src/radio

  git clone https://github.com/pothosware/SoapySDR.git
  mkdir SoapySDR/build; cd SoapySDR/build
  cmake ../ -DCMAKE_BUILD_TYPE=Release
  make -j4
  sudo make install
  sudo ldconfig
  SoapySDRUtil --info #test SoapySDR install
  cd ../..

  git clone https://github.com/jgaeddert/liquid-dsp
  cd liquid-dsp
  ./bootstrap.sh
  CFLAGS="-march=native -O3" ./configure --enable-fftoverride
  make -j4
  sudo make install
  sudo ldconfig
  cd ..

  wget https://github.com/wxWidgets/wxWidgets/releases/download/v3.1.5/wxWidgets-3.1.5.tar.bz2
  tar -xvjf wxWidgets-3.1.5.tar.bz2
  cd wxWidgets-3.1.5/
  mkdir -p ~/Develop/wxWidgets-staticlib
  ./autogen.sh
  ./configure --prefix=`echo ~/Develop/wxWidgets-staticlib` --with-opengl --disable-glcanvasegl --disable-shared --enable-monolithic --with-libjpeg --with-libtiff --with-libpng --with-zlib --disable-sdltest --enable-unicode --enable-display --enable-propgrid --disable-webview --disable-webviewwebkit CXXFLAGS="-std=c++0x"
  make -j4 && make install
  cd ..

  git clone https://github.com/cjcliffe/CubicSDR.git
  mkdir CubicSDR/build
  cd CubicSDR/build
  export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:/usr/local/lib64/libSoapySDR.so.8.1"
  cmake ../ -DUSE_HAMLIB=1 -DOTHER_LIBS="-latomic" -DCMAKE_BUILD_TYPE=Release -DwxWidgets_CONFIG_EXECUTABLE=~/Develop/wxWidgets-staticlib/bin/wx-config
  make
  mkdir -p ~/bin
  cp x64/CubicSDR ~/bin/cubic
  sudo make install
  cd ../..
fi
