import { Inspector } from "observablehq:runtime";
function inspect(value, expanded) {
  const node = document.createElement("div");
  new Inspector(node).fulfilled(value);
  if (expanded) {
    for (const path of expanded) {
      let child = node;
      for (const i of path)
        child = child?.childNodes[i];
      child?.dispatchEvent(new Event("mouseup"));
    }
  }
  return node;
}
function inspectError(value) {
  const node = document.createElement("div");
  new Inspector(node).rejected(value);
  node.classList.add("observablehq--error");
  return node;
}
export {
  inspect,
  inspectError
};
