"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.diff = void 0;
var lcs_1 = __importDefault(require("./lcs"));
function diff(a, b, compareFunc) {
    if (compareFunc === void 0) { compareFunc = function (ia, ib) { return ia === ib; }; }
    var ret = {
        removed: [],
        added: [],
    };
    (0, lcs_1.default)(a, b, compareFunc, function (type, oldArr, oldStart, oldEnd, newArr, newStart, newEnd) {
        if (type === 'add') {
            for (var i = newStart; i < newEnd; ++i) {
                ret.added.push(newArr[i]);
            }
        }
        else if (type === 'remove') {
            for (var i = oldStart; i < oldEnd; ++i) {
                ret.removed.push(oldArr[i]);
            }
        }
    });
    return ret;
}
exports.diff = diff;
