const sidebar = document.querySelector("#observablehq-sidebar");
const toggle = document.querySelector("#observablehq-sidebar-toggle");
const initialState = sessionStorage.getItem("observablehq-sidebar");
if (initialState)
  toggle.checked = initialState === "true";
else
  toggle.indeterminate = true;
for (const summary of document.querySelectorAll("#observablehq-sidebar summary")) {
  const details = summary.parentElement;
  switch (sessionStorage.getItem(`observablehq-sidebar:${summary.textContent}`)) {
    case "true":
      details.open = true;
      break;
    case "false":
      if (!details.classList.contains("observablehq-section-active"))
        details.open = false;
      break;
  }
}
addEventListener("beforeunload", () => sessionStorage.setItem("observablehq-sidebar-scrolly", `${sidebar.scrollTop}`));
const scrolly = sessionStorage.getItem("observablehq-sidebar-scrolly");
if (scrolly != null) {
  sidebar.style.cssText = "overflow: hidden;";
  sidebar.scrollTop = +scrolly;
  sidebar.style.cssText = "";
}
