import { file as _file } from "@observablehq/inputs";
import { AbstractFile } from "observablehq:stdlib";
import {
  button,
  checkbox,
  radio,
  toggle,
  color,
  date,
  datetime,
  form,
  range,
  number,
  search,
  searchFilter,
  select,
  table,
  text,
  email,
  tel,
  url,
  password,
  textarea,
  input,
  bind,
  disposal,
  formatDate,
  formatLocaleAuto,
  formatLocaleNumber,
  formatTrim,
  formatAuto,
  formatNumber
} from "@observablehq/inputs";
const file = (options) => _file({ ...options, transform: localFile });
function localFile(file2) {
  return new LocalFile(file2);
}
class LocalFile extends AbstractFile {
  constructor(file2) {
    super(file2.name, file2.type, file2.lastModified, file2.size);
    Object.defineProperty(this, "_", { value: file2 });
    Object.defineProperty(this, "_url", { writable: true });
  }
  get href() {
    return this._url ??= URL.createObjectURL(this._);
  }
  async url() {
    return this.href;
  }
  async blob() {
    return this._;
  }
  async stream() {
    return this._.stream();
  }
}
export {
  bind,
  button,
  checkbox,
  color,
  date,
  datetime,
  disposal,
  email,
  file,
  form,
  formatAuto,
  formatDate,
  formatLocaleAuto,
  formatLocaleNumber,
  formatNumber,
  formatTrim,
  input,
  number,
  password,
  radio,
  range,
  search,
  searchFilter,
  select,
  table,
  tel,
  text,
  textarea,
  toggle,
  url
};
