import { observe } from "./generators/observe.js";
function Mutable(value) {
  let change;
  return Object.defineProperty(
    observe((_) => {
      change = _;
      if (value !== void 0)
        change(value);
    }),
    "value",
    {
      get: () => value,
      set: (x) => void change(value = x)
      // eslint-disable-line no-setter-return
    }
  );
}
export {
  Mutable
};
