import JSZip from "npm:jszip";
import { AbstractFile } from "observablehq:stdlib";
class ZipArchive {
  constructor(archive) {
    Object.defineProperty(this, "_", { value: archive });
    this.filenames = Object.keys(archive.files).filter((name) => !archive.files[name].dir);
  }
  static async from(buffer) {
    return new ZipArchive(await JSZip.loadAsync(buffer));
  }
  file(path) {
    const object = this._.file(path = `${path}`);
    if (!object || object.dir)
      throw new Error(`file not found: ${path}`);
    return new ZipArchiveEntry(object);
  }
}
class ZipArchiveEntry extends AbstractFile {
  constructor(object) {
    super(object.name);
    Object.defineProperty(this, "_", { value: object });
    Object.defineProperty(this, "_url", { writable: true });
  }
  async url() {
    return this._url || (this._url = this.blob().then(URL.createObjectURL));
  }
  async blob() {
    return this._.async("blob");
  }
  async arrayBuffer() {
    return this._.async("arraybuffer");
  }
  async text() {
    return this._.async("text");
  }
  async json() {
    return JSON.parse(await this.text());
  }
}
export {
  ZipArchive
};
