import { watch } from "node:fs";
import { isEnoent } from "./error.js";
import { maybeStat } from "./files.js";
import { resolvePath } from "./path.js";
class FileWatchers {
  watchers = [];
  static async of(loaders, path, names, callback) {
    const that = new FileWatchers();
    const { watchers } = that;
    for (const name of names) {
      const watchPath = loaders.getWatchPath(resolvePath(path, name));
      if (!watchPath)
        continue;
      let currentStat = await maybeStat(watchPath);
      let watcher;
      const index = watchers.length;
      try {
        watcher = watch(watchPath, async function watched(type) {
          if (type === "rename") {
            watcher.close();
            try {
              watcher = watchers[index] = watch(watchPath, watched);
            } catch (error) {
              if (!isEnoent(error))
                throw error;
              console.error(`file no longer exists: ${watchPath}`);
              return;
            }
            setTimeout(() => watched("change"), 100);
            return;
          }
          const newStat = await maybeStat(watchPath);
          if (currentStat?.mtimeMs === newStat?.mtimeMs || newStat?.size === 0)
            return;
          currentStat = newStat;
          callback(name);
        });
      } catch (error) {
        if (!isEnoent(error))
          throw error;
        continue;
      }
      watchers[index] = watcher;
    }
    return that;
  }
  close() {
    this.watchers.forEach((w) => w.close());
    this.watchers.length = 0;
  }
}
export {
  FileWatchers
};
