function formatIsoDate(date) {
  return `${[pad(date.getFullYear(), 4), pad(date.getMonth() + 1, 2), pad(date.getDate(), 2)].join("-")}T${[
    pad(date.getHours(), 2),
    pad(date.getMinutes(), 2),
    pad(date.getSeconds(), 2)
  ].join(":")}`;
}
function formatLocaleDate(date, locale = "en-US") {
  return date.toLocaleDateString(locale, { month: "short", day: "numeric", year: "numeric" });
}
function pad(number, length) {
  return String(number).padStart(length, "0");
}
function formatByteSize(x, locale = "en-US") {
  const formatOptions = { maximumSignificantDigits: 3, maximumFractionDigits: 2 };
  for (const [k, suffix] of [
    [1e9, " GB"],
    [1e6, " MB"],
    [1e3, " kB"]
  ]) {
    if (Math.round(x / k * 1e3) >= 1e3) {
      return (x / k).toLocaleString(locale, formatOptions) + suffix;
    }
  }
  return x.toLocaleString(locale, formatOptions) + " B";
}
export {
  formatByteSize,
  formatIsoDate,
  formatLocaleDate
};
