import he from "he";
const CODE_TAB = 9, CODE_LF = 10, CODE_FF = 12, CODE_CR = 13, CODE_SPACE = 32, CODE_GT = 62, CODE_SLASH = 47, CODE_EQ = 61, CODE_DQUOTE = 34, CODE_SQUOTE = 39, STATE_TAG_NAME = 4, STATE_BEFORE_ATTRIBUTE_NAME = 6, STATE_AFTER_ATTRIBUTE_NAME = 7, STATE_ATTRIBUTE_NAME = 8, STATE_BEFORE_ATTRIBUTE_VALUE = 9, STATE_ATTRIBUTE_VALUE_DOUBLE_QUOTED = 10, STATE_ATTRIBUTE_VALUE_SINGLE_QUOTED = 11, STATE_ATTRIBUTE_VALUE_UNQUOTED = 12;
function parseInfo(input) {
  let state = STATE_TAG_NAME;
  let tag = "";
  let attributeName;
  let attributeNameStart;
  let attributeValueStart;
  const attributes = {};
  for (let i = 0, n = input.length; i <= n; ++i) {
    const code = input.charCodeAt(i);
    switch (state) {
      case STATE_TAG_NAME: {
        if (isSpaceCode(code) || isNaN(code)) {
          state = STATE_BEFORE_ATTRIBUTE_NAME;
          tag = lower(input, 0, i);
        }
        break;
      }
      case STATE_BEFORE_ATTRIBUTE_NAME: {
        if (isSpaceCode(code) || isNaN(code)) {
        } else if (code === CODE_SLASH || code === CODE_GT) {
          state = STATE_AFTER_ATTRIBUTE_NAME;
          --i;
        } else if (code === CODE_EQ) {
          attributeNameStart = i + 1;
          state = STATE_ATTRIBUTE_NAME;
        } else {
          attributeNameStart = i;
          state = STATE_ATTRIBUTE_NAME;
          --i;
        }
        break;
      }
      case STATE_ATTRIBUTE_NAME: {
        if (isSpaceCode(code) || isNaN(code) || code === CODE_SLASH || code === CODE_GT) {
          attributeName = lower(input, attributeNameStart, i);
          attributes[attributeName] = "";
          state = STATE_AFTER_ATTRIBUTE_NAME;
          --i;
        } else if (code === CODE_EQ) {
          state = STATE_BEFORE_ATTRIBUTE_VALUE;
          attributeName = lower(input, attributeNameStart, i);
          attributes[attributeName] = "";
        }
        break;
      }
      case STATE_AFTER_ATTRIBUTE_NAME: {
        if (isSpaceCode(code) || isNaN(code)) {
        } else if (code === CODE_SLASH) {
          state = STATE_BEFORE_ATTRIBUTE_NAME;
        } else if (code === CODE_EQ) {
          state = STATE_BEFORE_ATTRIBUTE_VALUE;
        } else if (code === CODE_GT) {
          state = STATE_BEFORE_ATTRIBUTE_NAME;
        } else {
          attributeNameStart = i;
          state = STATE_ATTRIBUTE_NAME;
          --i;
        }
        break;
      }
      case STATE_BEFORE_ATTRIBUTE_VALUE: {
        if (isSpaceCode(code) || isNaN(code)) {
        } else if (code === CODE_DQUOTE) {
          state = STATE_ATTRIBUTE_VALUE_DOUBLE_QUOTED;
          attributeValueStart = i + 1;
        } else if (code === CODE_SQUOTE) {
          state = STATE_ATTRIBUTE_VALUE_SINGLE_QUOTED;
          attributeValueStart = i + 1;
        } else if (code === CODE_GT) {
          state = STATE_BEFORE_ATTRIBUTE_NAME;
        } else {
          attributeValueStart = i;
          state = STATE_ATTRIBUTE_VALUE_UNQUOTED;
          --i;
        }
        break;
      }
      case STATE_ATTRIBUTE_VALUE_DOUBLE_QUOTED: {
        if (code === CODE_DQUOTE || isNaN(code)) {
          state = STATE_BEFORE_ATTRIBUTE_NAME;
          attributes[attributeName] = decode(input, attributeValueStart, i);
        }
        break;
      }
      case STATE_ATTRIBUTE_VALUE_SINGLE_QUOTED: {
        if (code === CODE_SQUOTE || isNaN(code)) {
          state = STATE_BEFORE_ATTRIBUTE_NAME;
          attributes[attributeName] = decode(input, attributeValueStart, i);
        }
        break;
      }
      case STATE_ATTRIBUTE_VALUE_UNQUOTED: {
        if (isSpaceCode(code) || isNaN(code) || code === CODE_GT) {
          state = STATE_BEFORE_ATTRIBUTE_NAME;
          attributes[attributeName] = decode(input, attributeValueStart, i);
        }
        break;
      }
    }
  }
  return { tag, attributes };
}
function isSpaceCode(code) {
  return code === CODE_TAB || code === CODE_LF || // normalize newlines
  code === CODE_FF || code === CODE_SPACE || code === CODE_CR;
}
function lower(input, start, end) {
  return input.slice(start, end).toLowerCase();
}
function decode(input, start, end) {
  return he.decode(input.slice(start, end), { isAttributeValue: true });
}
export {
  parseInfo
};
