import { simple } from "acorn-walk";
import { defaultGlobals } from "./globals.js";
import { syntaxError } from "./syntaxError.js";
function checkAssignments(node, references, input) {
  function checkConst(node2) {
    switch (node2.type) {
      case "Identifier":
        if (references.includes(node2))
          throw syntaxError(`Assignment to external variable '${node2.name}'`, node2, input);
        if (defaultGlobals.has(node2.name))
          throw syntaxError(`Assignment to global '${node2.name}'`, node2, input);
        break;
      case "ObjectPattern":
        node2.properties.forEach((node3) => checkConst(node3.type === "Property" ? node3.value : node3));
        break;
      case "ArrayPattern":
        node2.elements.forEach((node3) => node3 && checkConst(node3));
        break;
      case "RestElement":
        checkConst(node2.argument);
        break;
    }
  }
  function checkConstLeft({ left }) {
    checkConst(left);
  }
  function checkConstArgument({ argument }) {
    checkConst(argument);
  }
  simple(node, {
    AssignmentExpression: checkConstLeft,
    AssignmentPattern: checkConstLeft,
    UpdateExpression: checkConstArgument,
    ForOfStatement: checkConstLeft,
    ForInStatement: checkConstLeft
  });
}
export {
  checkAssignments
};
