import { simple } from "acorn-walk";
import { findReferences } from "./references.js";
import { syntaxError } from "./syntaxError.js";
function getParamName(param) {
  return param.property.type === "Identifier" ? param.property.name : param.property.value;
}
function checkParams(node, input, params) {
  for (const [name, param] of findParams(node, params, input)) {
    param.value = params[name];
  }
}
function findParams(body, params, input) {
  const matches = [];
  const references = findReferences(body, { filterReference: ({ name }) => name === "observable" });
  simple(body, {
    MemberExpression(node) {
      if (isParamReference(node)) {
        const name = getParamName(node);
        if (!(name in params))
          throw syntaxError(`undefined parameter: ${name}`, node, input);
        matches.push([name, node]);
      }
    }
  });
  function isParamReference(node) {
    if (node.object.type !== "MemberExpression" || node.object.object.type !== "Identifier" || node.object.object.name !== "observable" || node.object.property.type !== "Identifier" || node.object.property.name !== "params" || !references.includes(node.object.object)) {
      return false;
    }
    if (node.property.type !== "Identifier" && node.property.type !== "Literal") {
      throw syntaxError("invalid param reference", node, input);
    }
    return true;
  }
  return matches;
}
export {
  checkParams,
  findParams
};
