const linkCache = /* @__PURE__ */ new WeakMap();
function normalizePath(path) {
  return path.replace(/[?#].*$/, "");
}
function findLink(path, config) {
  const { pages } = config;
  let links = linkCache.get(pages);
  if (!links) {
    links = /* @__PURE__ */ new Map();
    for (const pageGroup of walk(config)) {
      let prev;
      for (const page of pageGroup) {
        const path2 = normalizePath(page.path);
        if (links.has(path2)) {
          console.warn(`ignoring duplicate page: ${page.path}`);
        } else {
          if (prev) {
            links.set(path2, { prev, next: void 0 });
            links.get(normalizePath(prev.path)).next = page;
          } else {
            links.set(path2, { prev: void 0, next: void 0 });
          }
          prev = page;
        }
      }
    }
    if (links.size === 1)
      links.clear();
    linkCache.set(pages, links);
  }
  return links.get(path);
}
function walk(config) {
  const { pages, loaders, title = "Home" } = config;
  const pageGroups = /* @__PURE__ */ new Map();
  const visited = /* @__PURE__ */ new Set();
  function visit(page) {
    if (visited.has(page.path) || !page.pager)
      return;
    visited.add(page.path);
    let pageGroup = pageGroups.get(page.pager);
    if (!pageGroup)
      pageGroups.set(page.pager, pageGroup = []);
    pageGroup.push(page);
  }
  if (loaders.findPage("/index"))
    visit({ name: title, path: "/index", pager: "main" });
  for (const page of pages) {
    if (page.path !== null)
      visit(page);
    if ("pages" in page)
      for (const p of page.pages)
        visit(p);
  }
  return pageGroups.values();
}
function* getPagePaths(config) {
  for (const pageGroup of walk(config)) {
    for (const page of pageGroup) {
      yield page.path;
    }
  }
}
export {
  findLink,
  getPagePaths,
  normalizePath
};
