import op from "node:path";
import { dirname, join } from "node:path/posix";
function relativePath(source, target) {
  if (/^\w+:/.test(target))
    return target;
  const from = join("/", source).split(/[/]+/g).slice(0, -1);
  const to = join("/", target).split(/[/]+/g);
  const f = to.pop();
  const m = from.length;
  const n = Math.min(m, to.length);
  let i = 0;
  while (i < n && from[i] === to[i])
    ++i;
  const k = m - i;
  return (k ? "../".repeat(k) : "./") + to.slice(i).concat(f).join("/");
}
function resolvePath(root, source, target) {
  if (target === void 0)
    target = source, source = root, root = ".";
  const path = join(root, target === "" ? source : target.startsWith("/") ? "." : dirname(source), target);
  return path.startsWith("../") ? path : join("/", path);
}
function resolveLocalPath(source, target) {
  if (/^\w+:/.test(target))
    return null;
  if (target.startsWith("#"))
    return null;
  const path = resolvePath(source, target);
  if (path.startsWith("../"))
    return null;
  return path;
}
function isPathImport(specifier) {
  return ["./", "../", "/"].some((prefix) => specifier.startsWith(prefix));
}
function isAssetPath(specifier) {
  return !/^(\w+:|#)/.test(specifier);
}
function resolveRelativePath(source, target) {
  return relativePath(source, resolvePath(source, target));
}
function parseRelativeUrl(url) {
  let search;
  let hash;
  const i = url.indexOf("#");
  if (i < 0)
    hash = "";
  else
    hash = url.slice(i), url = url.slice(0, i);
  const j = url.indexOf("?");
  if (j < 0)
    search = "";
  else
    search = url.slice(j), url = url.slice(0, j);
  return { pathname: url, search, hash };
}
function within(root, path) {
  const { relative, normalize, resolve, isAbsolute } = op;
  path = relative(normalize(resolve(root)), normalize(resolve(path)));
  return !path.startsWith("..") && !isAbsolute(path);
}
export {
  isAssetPath,
  isPathImport,
  parseRelativeUrl,
  relativePath,
  resolveLocalPath,
  resolvePath,
  resolveRelativePath,
  within
};
