import { Parser, tokTypes } from "acorn";
import { acornOptions } from "./javascript/parse.js";
import { transpileTag } from "./tag.js";
function transpileSql(content, { id, display } = {}) {
  if (id !== void 0 && !isValidBinding(id))
    throw new SyntaxError(`invalid binding: ${id}`);
  const sql = transpileTag(content, "sql", true);
  display = display === void 0 ? id === void 0 ? "" : "false" : display.toLowerCase();
  return id === void 0 ? display === "false" ? `${sql};` : `display(Inputs.table(await ${sql}, {select: false}));` : display === "false" ? `const ${id} = await ${sql};` : `const ${id} = ((_) => (display(Inputs.table(_, {select: false})), _))(await ${sql});`;
}
function isValidBinding(input) {
  try {
    const parser = new Parser(acornOptions, input, 0);
    parser.nextToken();
    const token = parser.parseBindingAtom();
    if (token.start !== 0 || token.end !== input.length)
      return false;
    if (parser.type !== tokTypes.eof)
      return false;
    return true;
  } catch {
    return false;
  }
}
export {
  transpileSql
};
