function resize(render, invalidation) {
  const div = document.createElement("div");
  div.style.position = "relative";
  if (render.length !== 1)
    div.style.height = "100%";
  let currentRender = 0;
  let currentDisplay = 0;
  let currentWidth;
  const observer = new ResizeObserver(async ([entry]) => {
    const { width, height } = entry.contentRect;
    if (render.length === 1 && width === currentWidth)
      return;
    currentWidth = width;
    const childRender = ++currentRender;
    const child = width > 0 ? await render(width, height) : null;
    if (currentDisplay > childRender)
      return;
    currentDisplay = childRender;
    while (div.lastChild)
      div.lastChild.remove();
    if (child == null)
      return;
    if (render.length !== 1 && isElement(child))
      child.style.position = "absolute";
    div.append(child);
  });
  observer.observe(div);
  invalidation?.then(() => observer.disconnect());
  return div;
}
function isElement(node) {
  return typeof node === "object" && node.nodeType === 1;
}
export {
  resize
};
