function isLiteral(node) {
  return node.type === "Literal";
}
function isTemplateLiteral(node) {
  return node.type === "TemplateLiteral";
}
function isStringLiteral(node) {
  return isLiteral(node) ? /^['"]/.test(node.raw) : isTemplateLiteral(node) ? node.expressions.every(isStringLiteral) : isBinaryExpression(node) ? node.operator === "+" && isStringLiteral(node.left) && isStringLiteral(node.right) : isMemberExpression(node) ? "value" in node : false;
}
function getStringLiteralValue(node) {
  return node.type === "TemplateLiteral" ? getTemplateLiteralValue(node) : node.type === "BinaryExpression" ? getBinaryExpressionValue(node) : node.value;
}
function getTemplateLiteralValue(node) {
  let value = node.quasis[0].value.cooked;
  for (let i = 0; i < node.expressions.length; ++i) {
    value += getStringLiteralValue(node.expressions[i]);
    value += node.quasis[i + 1].value.cooked;
  }
  return value;
}
function getBinaryExpressionValue(node) {
  return getStringLiteralValue(node.left) + getStringLiteralValue(node.right);
}
function isMemberExpression(node) {
  return node.type === "MemberExpression";
}
function isBinaryExpression(node) {
  return node.type === "BinaryExpression";
}
export {
  getStringLiteralValue,
  isLiteral,
  isStringLiteral,
  isTemplateLiteral
};
