import { isatty } from "node:tty";
import * as clack from "@clack/prompts";
import pc from "picocolors";
const reset = pc.reset;
const bold = pc.bold;
const faint = pc.gray;
const italic = pc.italic;
const underline = pc.underline;
const inverse = pc.inverse;
const strikethrough = pc.strikethrough;
const red = pc.red;
const green = pc.green;
const yellow = pc.yellow;
const blue = pc.blue;
const magenta = pc.magenta;
const cyan = pc.cyan;
const noSpinner = () => ({
  start(msg) {
    console.log(msg);
  },
  stop(msg, code) {
    console.log(msg, code ?? "");
  },
  message(msg) {
    console.log(msg);
  }
});
const defaultEffects = {
  clack: process.stdout.isTTY ? clack : { ...clack, spinner: noSpinner },
  isTty: isatty(process.stdin.fd),
  logger: console,
  outputColumns: Math.min(80, process.stdout.columns ?? 80)
};
function stripColor(s) {
  return s.replace(/\x1b\[[0-9;]*m/g, "");
}
function hangingIndentLog(effects, prefix, message) {
  let output;
  let indent;
  if (effects.isTty) {
    const prefixLength = stripColor(prefix).length + 1;
    const lineBudget = effects.outputColumns - prefixLength;
    const tokens = message.split(" ");
    const lines = [[]];
    indent = " ".repeat(prefixLength);
    let lastLineLength = 0;
    while (tokens.length) {
      let token = tokens.shift();
      let newline = false;
      if (token.includes("\n")) {
        let rest;
        [token, rest] = token.split("\n", 2);
        tokens.unshift(rest);
        newline = true;
      }
      const tokenLength = stripColor(token).length;
      lastLineLength += tokenLength + 1;
      if (lastLineLength > lineBudget) {
        lines.push([]);
        lastLineLength = tokenLength;
      }
      lines.at(-1)?.push(token);
      if (newline) {
        lines.push([]);
        lastLineLength = tokenLength;
      }
    }
    output = prefix + " ";
    output += lines.map((line) => line.join(" ")).join("\n" + indent);
  } else {
    output = `${prefix} ${message}`;
    indent = "";
  }
  effects.logger.log(output);
  return { output, indent };
}
function link(url) {
  if (url instanceof URL)
    url = url.href;
  return underline(url);
}
export {
  blue,
  bold,
  cyan,
  defaultEffects,
  faint,
  green,
  hangingIndentLog,
  inverse,
  italic,
  link,
  magenta,
  red,
  reset,
  strikethrough,
  stripColor,
  underline,
  yellow
};
