const container = document.querySelector("#observablehq-search");
container.setAttribute("data-shortcut", `${/Mac|iPhone/.test(navigator.platform) ? "\u2318" : "Alt-"}K`);
const input = container.querySelector("input");
const load = () => import("observablehq:search");
input.addEventListener("focus", load, { once: true });
input.addEventListener("keydown", load, { once: true });
const toggle = document.querySelector("#observablehq-sidebar-toggle");
addEventListener("keydown", (event) => {
  if (event.code === "KeyK" && event.metaKey && !event.altKey && !event.ctrlKey || event.key === "/" && !event.metaKey && !event.altKey && !event.ctrlKey && event.target === document.body) {
    if (toggle.checked)
      input.focus();
    else
      toggle.click(), input.focus(), toggle.click();
    input.select();
    event.preventDefault();
  }
});
