import { observe } from "./observe.js";
function dark() {
  return observe((notify) => {
    let dark2;
    const media = matchMedia("(prefers-color-scheme: dark)");
    const probe = document.createElement("div");
    probe.style.transitionProperty = "color, background-color";
    probe.style.transitionDuration = "1ms";
    const changed = () => {
      const s = getComputedStyle(document.body).getPropertyValue("color-scheme").split(/\s+/);
      let d;
      if (s.includes("light") && s.includes("dark"))
        d = media.matches;
      else
        d = s.includes("dark");
      if (dark2 === d)
        return;
      notify(dark2 = d);
    };
    document.body.appendChild(probe);
    changed();
    probe.addEventListener("transitionstart", changed);
    media.addEventListener("change", changed);
    return () => {
      probe.removeEventListener("transitionstart", changed);
      media.removeEventListener("change", changed);
    };
  });
}
export {
  dark
};
