import { observe } from "./observe.js";
function width(target, options) {
  return observe((notify) => {
    let width2;
    const observer = new ResizeObserver(([entry]) => {
      const w = entry.contentRect.width;
      if (w !== width2)
        notify(width2 = w);
    });
    observer.observe(target, options);
    return () => observer.disconnect();
  });
}
export {
  width
};
