import { defaultGlobals } from "./globals.js";
import { syntaxError } from "./syntaxError.js";
function findDeclarations(node, input) {
  const declarations = [];
  function declareLocal(node2) {
    if (defaultGlobals.has(node2.name) || node2.name === "arguments") {
      throw syntaxError(`Global '${node2.name}' cannot be redefined`, node2, input);
    }
    declarations.push(node2);
  }
  function declarePattern(node2) {
    switch (node2.type) {
      case "Identifier":
        declareLocal(node2);
        break;
      case "ObjectPattern":
        node2.properties.forEach((node3) => declarePattern(node3.type === "Property" ? node3.value : node3));
        break;
      case "ArrayPattern":
        node2.elements.forEach((node3) => node3 && declarePattern(node3));
        break;
      case "RestElement":
        declarePattern(node2.argument);
        break;
      case "AssignmentPattern":
        declarePattern(node2.left);
        break;
    }
  }
  for (const child of node.body) {
    switch (child.type) {
      case "VariableDeclaration":
        child.declarations.forEach((node2) => declarePattern(node2.id));
        break;
      case "ClassDeclaration":
      case "FunctionDeclaration":
        declareLocal(child.id);
        break;
      case "ImportDeclaration":
        child.specifiers.forEach((node2) => declareLocal(node2.local));
        break;
    }
  }
  return declarations;
}
export {
  findDeclarations
};
