import { defineConfig } from "@solidjs/start/config";

/* @ts-ignore */
import pkg from "@vinxi/plugin-mdx";
import wasm from "vite-plugin-wasm"
import topLevelAwait from "vite-plugin-top-level-await"
import devtools from "solid-devtools/vite"

const { default: mdx } = pkg;
export default defineConfig({
  extensions: ["mdx", "md"],
  vite: {
    plugins: [
      devtools({ autoname: true, }),
      mdx.withImports({})({
        jsx: true,
        jsxImportSource: "solid-js",
        providerImportSource: "solid-mdx",
      }),
      wasm(),
      topLevelAwait(),
    ]
  }
});
