import { fn } from 'storybook/test';

import Counter from '../src/components/Counter';

// More on how to set up stories at: https://storybook.js.org/docs/writing-stories#default-export
export default {
  title: 'Example/Counter',
  component: Counter,

  // See: https://storybook.js.org/docs/configure/story-layout
  parameters: { layout: 'centered', },

  // See: https://storybook.js.org/docs/writing-docs/autodocs
  tags: ['autodocs'],

  // See: https://storybook.js.org/docs/api/argtypes
  argTypes: {
    backgroundColor: { control: 'color' },
  },
  // Use `fn` to spy on the onClick arg, which will appear in the actions panel once invoked: https://storybook.js.org/docs/essentials/actions#action-args
  args: { onClick: fn() },
};

// See: https://storybook.js.org/docs/writing-stories/args
export const Primary = {
  args: {
    primary: true,
    label: 'Button',
  },
};

export const Secondary = {
  args: {
    label: 'Button',
  },
};

export const Large = {
  args: {
    size: 'large',
    label: 'Button',
  },
};

export const Small = {
  args: {
    size: 'small',
    label: 'Button',
  },
};


export const InCSFFormat = () => {
  return <Button size="small" label="Button" />;
};


export const WithDecorator = {
  args: {
    size: 'small',
    label: 'Button',
    primary: true,
  },
  decorators: [
    (Story: any, context: any) => {
      return (
        <div style={ { border: '1px dashed red', padding: '10px' } }>
          <Story { ...context.args } />
        </div>
      );
    },
  ],
};
