import { Router } from "@solidjs/router"
import { FileRoutes } from "@solidjs/start/router"
import { Suspense, createEffect, onMount } from "solid-js"
import { createStore } from "solid-js/store"
import 'solid-devtools'

import { scheme, s, c } from "./scheme"
import './app.css'
import { ThemeProvider, base, second } from './scheme'
import { Memory } from "./memory"

import { add, Impulse } from "../lib/ripple.js";

// wasm experiment
console.log(add(1, 1));
const sample = new Impulse("sound");
console.log(sample.pulse());

export default () => {
  const basis = { scheme: 0, }
  const [mem, remember] = createStore(basis)

  onMount(() => {
    let prior = localStorage.getItem("mem")
    if(prior) remember(JSON.parse(prior))
  })

  createEffect(() => {
    localStorage.setItem("mem", JSON.stringify(mem))
  })

  return (
    <Memory.Provider value={{mem, remember}} >
    <ThemeProvider theme={base}>
    <Router root={(props) => (
      <Main>
        <a href="/">Index</a>
        <a href="/colors">Colors</a>
        <Suspense>{props.children}</Suspense>
      </Main>
    )} >
      <FileRoutes />
    </Router>
    </ThemeProvider>
    </Memory.Provider>
  )
}

const Main = scheme('main')`

background: ${c(0)};
color: ${c(1)};
text-align: center;
padding: 1em;
overflow-y: scroll;
font-family: Gordita, Roboto, Oxygen, Ubuntu, Cantarell, "Open Sans", "Helvetica Neue", sans-serif;

a {
  color: ${c(2)};
  margin-right: 1rem;
}

h1 {
  color: ${c(4)};
  text-transform: uppercase;
  font-size: 4rem;
  font-weight: 100;
  line-height: 1.1;
  margin: 4rem auto;
  max-width: 14rem;
}

p {
  max-width: 14rem;
  margin: 2rem auto;
  line-height: 1.35;
}

@media (min-width: 480px) {
  h1 { max-width: none; }
  p { max-width: none; }
}
`
