import { scheme } from "../scheme"
import schemes from 'nice-color-palettes'
import memory, { memo } from "../memory"

export default function ColorBanner({num}) {
  const { mem, remember } = memory()
  let n = memo(() => num > -1 ? num : mem.scheme)

  return (
    <Row onClick={() => remember('scheme', n()) } >
      <Label>{n()}:</Label>
      {schemes[n()].map(color => (
        <Cell key={color} color={color} />
      ))}
    </Row>
  );
}

const Row = scheme("div")`
  display: flex;
  flex-direction: row;
  margin-bottom: 0.2rem;
`

const Label = scheme("span")`
  margin-right: 1rem;
`

const Cell = scheme("div")`
  height: 3vw;
  width:  3vw;
  background-color: ${p => p.color};
  content: ".";
`
