import { createSignal } from "solid-js";
import { scheme, s } from "../scheme"

export default function Counter() {
  const [count, setCount] = createSignal(0);

  const interval = setInterval(
    () => setCount(c => c + 1),
    1000
  );

  return (
    <Button class="increment"
      onClick={() => setCount(0)}
      type="button">
      Seconds: {count()}
    </Button>
  );
}

const Button = scheme("button")`
  font-family: inherit;
  font-size: inherit;
  padding: 1em 2em;
  background-color: ${s('colors.primary')};
  border-radius: 2em;
  border: 2px solid rgba(68, 107, 158, 0);
  outline: none;
  width: 200px;
  font-variant-numeric: tabular-nums;
  cursor: pointer;

  &:focus { border: 2px solid #335d92; }
  &:active { background-color: rgba(68, 107, 158, 0.2); }
`
